/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind;

import io.gitlab.jfronny.commons.Serializer;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;
import io.gitlab.jfronny.commons.serialize.Transport;
import io.gitlab.jfronny.commons.serialize.databind.ObjectMapper;
import io.gitlab.jfronny.commons.serialize.databind.api.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.Objects;

public class DatabindSerializer<TEx extends Exception, Reader extends SerializeReader<TEx, Reader>, Writer extends SerializeWriter<TEx, Writer>>
implements Serializer {
    private final Transport<TEx, Reader, Writer> transport;
    private final ObjectMapper mapper;

    public DatabindSerializer(Transport<TEx, Reader, Writer> transport, ObjectMapper mapper) {
        this.transport = Objects.requireNonNull(transport);
        this.mapper = Objects.requireNonNull(mapper);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public String serialize(Object object) throws IOException {
        try (StringWriter sw = new StringWriter();){
            String string;
            block13: {
                Writer writer = this.transport.createWriter(sw);
                try {
                    this.mapper.serialize(object, writer);
                    ((SerializeWriter)writer).close();
                    string = sw.toString();
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            ((SerializeWriter)writer).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ((SerializeWriter)writer).close();
            }
            return string;
        }
        catch (Throwable e) {
            IOException x;
            throw e instanceof IOException ? (x = (IOException)e) : new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(Reader source, Type typeOfT) throws IOException {
        try (Reader reader = this.transport.createReader(source);){
            Object obj = this.mapper.getAdapter(TypeToken.get(typeOfT)).deserialize(reader);
            return (T)obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T deserialize(String source, Type typeOfT) throws IOException {
        try (Reader reader = this.transport.createReader(source);){
            Object obj = this.mapper.getAdapter(TypeToken.get(typeOfT)).deserialize(reader);
            return (T)obj;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getFormatMime() {
        return this.transport.getFormatMime();
    }
}

